/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.util.calcul;

import org.opensi.util.tools.Arrondi;


public abstract class CalculVentilTVA {

	protected double tauxTVA = 0;
	protected double pRemise = 0;
	protected double montantHT = 0;
	protected double montantTTC = 0;
	protected double montantTVAHorsFrais = 0;
	protected double montantHTHorsFrais = 0;
	protected double montantTTCHorsFrais = 0;
	protected double montantTVAHorsRemiseHorsFrais = 0;
	protected double montantHTHorsRemiseHorsFrais = 0;
	protected double montantTTCHorsRemiseHorsFrais = 0;

	protected double montantTTCHRemHF = 0;
	protected double montantHTHRemHF = 0;
	protected double montantTVAHRemHF = 0;
	protected double montantTTCHRemHRisHF = 0;
	protected double montantHTHRemHRisHF = 0;
	protected double montantTVAHRemHRisHF = 0;

	protected boolean npr = false;
	
	protected double mQuantifieLigneTotal = 0;
	protected double mQuantifieLigneTotalHRHF = 0;
	protected double baseHTb = 0;
	protected double baseTTCb = 0;
	protected double baseHTn = 0;
	protected double montantTVA = 0;
	protected double mRemiseb = 0;
	protected double baseTTCN = 0;

	protected double baseHTbHRHF = 0;
	protected double baseTTCbHRHF = 0;
	protected double baseHTnHRHF = 0;
	protected double montantTVAHRHF = 0;
	protected double mRemisebHRHF = 0;
	protected double baseTTCNHRHF = 0;
	
	protected double mQuantifieLigneTotalHF = 0;
	protected double baseTTCbHF = 0;
	protected double mRemisebHF = 0;
	protected double baseHTbHF = 0;
	protected double baseTTCNHF = 0;
	protected double baseHTnHF = 0;
	protected double montantTVAHF = 0;


	
	protected double fraisN = 0;

	
	protected Arrondi r2 = new Arrondi(2);
	
	public CalculVentilTVA() {
	}
		
	public void addLigne(double tauxTVA, double montantBase, boolean ttc, double montantBaseHorsRemise, double pRemise, boolean frais) {

		this.tauxTVA = tauxTVA;
		if (!frais) {
			this.pRemise = pRemise;
		}
		this.add(montantBase, ttc, montantBaseHorsRemise, frais);
	}

	public abstract void add(double montantBase, boolean ttc, double montantBaseHorsRemise, boolean frais);
	
	public void setNPR(boolean npr) {
		this.npr = npr;
	}
	
	public abstract double getMontantHT();
	public abstract double getMontantHTB(); 
	public abstract double getMontantHTN();
 	public abstract double getMontantTTC();
 	public abstract double getMontantTTCB();
 	public abstract double getMontantTTCN();
 	public abstract double getMontantTVA();
	public abstract double getMontantRemise();
	public abstract double getMontantHTHF();
 	public abstract double getMontantTTCHF();
 	public abstract double getMontantTVAHF();
	public abstract double getMontantHTHRemHF();
 	public abstract double getMontantTTCHRemHF();
 	public abstract double getMontantTVAHRemHF();

 	public double getTauxTVA() { return tauxTVA; }    
 	public boolean getNPR() { return npr; }    

} // fin VentilTVA
	

	
