/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.util.calcul;


public class CalculVentilTVAV1 extends CalculVentilTVA {

	public void add(double montantBase, boolean ttc, double montantBaseHRis, boolean frais) {
		if (ttc) {
			this.montantTTC = montantTTC + (montantBase * (1-pRemise/100));
			this.montantTVA = montantTTC * (tauxTVA/100) / (1 + tauxTVA/100);
			this.montantHT = montantTTC - montantTVA;
			if (!frais) {
				this.montantTTCHRemHF = montantTTCHRemHF + montantBase;
				this.montantTVAHRemHF = montantTTCHRemHF * (tauxTVA/100) / (1 + tauxTVA/100);
				this.montantHTHRemHF = montantTTCHRemHF - montantTVAHRemHF;
				
				this.montantTTCHRemHRisHF = montantTTCHRemHRisHF + montantBaseHRis;
				this.montantTVAHRemHRisHF = montantTTCHRemHRisHF * (tauxTVA/100) / (1 + tauxTVA/100);
				this.montantHTHRemHRisHF = montantTTCHRemHRisHF - montantTVAHRemHRisHF;
			}
		}
		else {
			this.montantHT = montantHT + montantBase * (1-pRemise/100);
			this.montantTVA = montantHT * (tauxTVA/100);
			this.montantTTC = montantHT + montantTVA;

			if (!frais) {
				this.montantHTHRemHF = montantHTHRemHF + montantBase;
				this.montantTVAHRemHF = montantHTHRemHF * (tauxTVA/100);
				this.montantTTCHRemHF = montantHTHRemHF + montantTVAHRemHF;

				this.montantHTHRemHRisHF = montantHTHRemHRisHF + montantBaseHRis;
				this.montantTVAHRemHRisHF = montantHTHRemHRisHF * (tauxTVA/100);
				this.montantTTCHRemHRisHF = montantHTHRemHRisHF + montantTVAHRemHRisHF;
			}
		}
	}	
 	
	public double getMontantHT() { return montantHT; }   
	public double getMontantHTB() { return montantHT; }   
	public double getMontantHTN() { return montantHT; }   
 	public double getMontantTTC() { return montantTTC; }    
 	public double getMontantTTCB() { return montantTTC; }    
 	public double getMontantTTCN() { return montantTTC; }    
 	public double getMontantTVA() { return montantTVA; }   
	public double getMontantHTHF() { return montantHTHRemHF; }
 	public double getMontantTTCHF() { return montantTTCHRemHF; }
 	public double getMontantTVAHF() { return montantTVAHRemHF; }
	public double getMontantHTHRemHF() { return montantHTHRemHRisHF; }   
 	public double getMontantTTCHRemHF() { return montantTTCHRemHRisHF; }    
 	public double getMontantTVAHRemHF() { return montantTVAHRemHRisHF; }

	public double getMontantRemise() {return 0;}    

	
} // fin VentilTVA
