/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes d'une ligne de facture standard
 */

package org.opensi.util.calcul;

import org.opensi.util.tools.Arrondi;

public abstract class LigneDocument {	

	protected Arrondi r2 = new Arrondi(2);
	protected Arrondi r4 = new Arrondi(4);

	protected double quantite = 0;
	protected double prixUnitaire = 0;
	protected double prixUnitaireNet = 0;
	protected double prixUnitaireNetCommissionne = 0;
	protected double mQuantifieCommissionneLigne = 0;
	protected double mQuantifieCommissionLigne = 0;
	protected double mQuantifieLigne = 0;
	protected double mQuantifieHorsRistourneLigne = 0;

	protected double pRistourne = 0;
	protected double mRistourne = 0;
	protected double pCommission = 0;
	protected double mCommission = 0;
	protected double tTVACommission = 0;
	protected double montantLigne = 0;
	protected double tauxTVA = 0;
	protected double prixAchat = 0;
	protected double mMarge = 0;
	protected double pMarge = 0;
	protected double mLigneHT = 0;
	protected double mLigneTTC = 0;
	protected boolean editionTTC = false;

	protected void addLigne(double quantite, double prixUnitaire, double ristourne,double tauxTVA,double pCommission,double tTVACommission, double prixAchat, boolean editionTTC)
	{ 
		this.quantite = quantite;
		this.prixUnitaire = prixUnitaire;
		this.pRistourne = ristourne;
		this.tauxTVA = tauxTVA;
		this.pCommission = pCommission;
		this.tTVACommission = tTVACommission;
		this.prixAchat = prixAchat;
		this.editionTTC = editionTTC;
		
		calculTotalLigne();
		
	}
	protected abstract void calculTotalLigne();
	
	public double getMontantMarge() { return mMarge; }   

}
