/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes d'une ligne de facture standard
 */

package org.opensi.util.calcul;

public class LigneDocumentV2 extends LigneDocument {	

	public void calculTotalLigne()
	{ 
		this.mRistourne = r4.round(prixUnitaire * (pRistourne/100));
		this.prixUnitaireNet = r4.round(prixUnitaire - mRistourne);
		this.mCommission = r4.round(prixUnitaireNet * (pCommission/100));
		this.prixUnitaireNetCommissionne = r4.round(prixUnitaireNet - mCommission);
		this.mQuantifieCommissionLigne = r2.round(mCommission * quantite);
		this.mQuantifieLigne = r2.round(prixUnitaireNet * quantite);
		this.mQuantifieCommissionneLigne = r2.round(mQuantifieLigne - mQuantifieCommissionLigne);
		this.mQuantifieHorsRistourneLigne = r2.round(prixUnitaire * quantite);
		
		if (editionTTC) {
			mLigneHT = r2.round((mQuantifieLigne / (1 +(tauxTVA*100))));
			mLigneTTC = mQuantifieLigne;
			mMarge =r2.round( mQuantifieLigne - (prixAchat*quantite));
			pMarge = r2.round((mLigneHT!=0)?mMarge / (mLigneHT*100):0);
		}
		else {
			mLigneHT = mQuantifieLigne;
			mLigneTTC = r2.round((mQuantifieLigne * (1 +(tauxTVA/100))));
			mMarge = r2.round(mQuantifieLigne - (prixAchat*quantite));
			pMarge = r2.round((mLigneHT!=0)?mMarge / (mLigneHT*100):0);
		}
	}
}
