/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.util.openoffice;

/**
* Pour gnrer les styles d'Ooo
*/

public class OooStyleCellule extends OooStyle
{


	/* CONSTANTES*/
	//H comme horizontalement
	/**
	 * alignement horizontal centr
	 */
	public final static int H_CENTRE=0;
	/**
	 * alignement horizontal  gauche
	 */
	public final static int H_GAUCHE=1;
	/**
	 * alignement horizontal  droite
	 */
	public final static int H_DROITE=2;
	
	
	/**
	 * alignement vertical en bas
	 */
	public final static int V_BAS=3;
	/**
	 * alignement vertical en haut
	 */
	public final static int V_HAUT=4;
	/**
	 * alignement vertical au milieu
	 */
	public final static int V_MILIEU=5;

	/**
	 * couleur noire en hexa dcimal: #000000
	 */
	public final static String NOIR="#000000";
	/**
	 * couleur blanche en hexadecimal: #ffffff
	 */
	public final static String BLANC="#ffffff";
	
	/**
	 * epaisseur de bordure par dfaut
	 */
	public final static float EPAISSEUR_DEFAUT=0.035f;

	public final static int FORMAT_NOMBRE_ENTIER=6;
	public final static int FORMAT_NOMBRE_FLOAT=7;
	public final static int FORMAT_STRING=8;



	/*Attributs*/
	private int alignH, alignV, taillePolice, formatTexte;
	private String couleurFond, couleurPolice;
	private boolean estItalique, estGras, estSouligne;
	private boolean estBordure;
	/**
	 * Style par dfaut:
	 * alignement en bas  gauche, texte noir, non gras, non italique et non soulign
	 * @param leNomStyle identifiant du style, dans un document Openoffice, deux styles ne doivent pas avoir le mme nom.
	 */
	public OooStyleCellule(String leNomStyle)
	{
		super(leNomStyle);
		
		alignH=H_GAUCHE;
		alignV=V_BAS;
		
		couleurFond=BLANC;
		couleurPolice=NOIR;
		
		taillePolice=10;
		
		estItalique=false;
		estGras=false;
		estSouligne=false;
		
		estBordure=false;
		
		formatTexte=FORMAT_STRING;
	}
	

	public void setFormatNombre(int format)
	{
		if(format==FORMAT_NOMBRE_ENTIER || format==FORMAT_NOMBRE_FLOAT || format==FORMAT_STRING)
		{
			formatTexte=format;
			System.out.println("J'ai mis le format au texte");
		}
		else
		{
			System.out.println("Je n'ai pas mis le format au texte "+format);
		}
		
	}


	public String getFamilleStyle()
	{
		return "table-cell";
	}
	
	
	/**
	 * Retourne la chaine de caractre reprsentant la ou les proprits associes au style
	 * @return proprit du style
	 */
	public String getPropriete()
	{
		String resultat="";
		
		if(!(couleurFond.equalsIgnoreCase("#ffffff"))) 	resultat+=" fo:background-color=\""+couleurFond+"\"";
		if(!(couleurFond.equalsIgnoreCase("#000000"))) 	resultat+=" fo:color=\""+couleurPolice+"\"";
		if(taillePolice!=10)														resultat+=" fo:font-size=\""+taillePolice+"pt\"";
		if(estGras) 																		resultat+=" fo:font-weight=\"bold\"";
		if(estItalique)																	resultat+=" fo:font-style=\"italic\"";
		if(estSouligne)																	resultat+=" style:text-underline=\"single\"";
		if(estBordure)																	resultat+=" fo:border=\"0.035cm solid #000000\"";
		resultat+=alignToString();
		
		return resultat;
	}
	
	
	
	
	/**
	 * Texte en italique
	 * @param italique si vrai: le texte est mis en italique
	 * si faux: le texte n'est pas mis en italique
	 */
	public void setItalique(boolean italique)
	{
		estItalique=italique;
	}
	
	/**
	 * Pour mettre la bordure, ou l'enlever
	 * true pour la mettre, false pour l'enlever
	 * @param bordure true pour mettre une bordure  la cellule, false sinon
	 */
	public void setBordure(boolean bordure)
	{
		estBordure=bordure;
	}

	/**
	 * Texte souligne
	 * @param souligne souligne=true pour souligner le texte, false=non soulign
	 */
	public void setSouligne(boolean souligne)
	{
		estSouligne=souligne;
	}
	
	
	/**
	 * Texte en gras
	 * @param gras gras=true pour mettre la police en gras, false=non gras
	 */
	public void setGras(boolean gras)
	{
		estGras=gras;
	}
	
	
	
	/**
	 * Taille de la police, 10 par dfaut
	 * taille comprise entre 2 et 999
	 * @param taille nouvelle taille de la police
	 */
	public void setTaillePolice(int taille)
	{
		if(taille<2)
		{
			taillePolice=2;
		}
		else if (taille>999)
		{
			taillePolice=999;
		}
		else
		{
			taillePolice=taille;
		}
	}
	
	
	/**
	 * Couleur de fond de la cellule en hexdcimal(code html), par exemple #a45566
	 * @param hexaCouleur nouvelle couleur de fond
	 */
	public void setCouleurFond(String hexaCouleur)
	{
		if (!(hexaCouleur.matches("#[0-9a-fA-F]{6}")))
		{
			couleurFond=BLANC;
		}
		else
		{
			couleurFond=hexaCouleur;
		}
	}
	
	
	
	/**
	 * Couleur du texte de la cellule en hexdcimal(code html), par exemple #a45566
	 * @param hexaCouleur nouvelle couleur de la police
	 */
	public void setCouleurPolice(String hexaCouleur)
	{
		if (!(hexaCouleur.matches("#[0-9a-fA-F]{6}")))
		{
			couleurPolice=NOIR;
		}
		else
		{
			couleurPolice=hexaCouleur;
		}
	}
	
	
	
	
	/**
	 * Pour fixer l'alignement horizontal du texte dans la cellule:
	 * H_CENTRE, H_GAUCHE ou H_DROITE
	 * @param H_align H_CENTRE, H_GAUCHE ou H_DROITE
	 */
	public void setAlignementHorizontal(int H_align)
	{
		if (H_align!=H_CENTRE&&H_align!=H_GAUCHE&&H_align!=H_DROITE)
		{

			alignH=H_GAUCHE;
		}
		else
		{

			alignH=H_align;
		}
	}
	
	
	
	/**
	 * Pour fixer l'alignement vertical du texte dans la cellule:
	 * V_BAS, V_HAUT ou V_MILIEU
	 * @param V_align V_BAS, V_HAUT ou V_MILIEU
	 */
	public void setAlignementVertical(int V_align)
	{
		if (V_align!=V_BAS && V_align!=V_HAUT && V_align!=V_MILIEU)
		{
			alignV=V_BAS;
		}
		else
		{
			alignV=V_align;
		}
	}
	
	
	/**
		 * Pour fixer la position du texte dans la cellule
		 * @param H_align H_CENTRE, H_GAUCHE ou H_DROITE
		 * @param V_align V_BAS, V_HAUT ou V_MILIEU
		 */
		public void setAlignement(int H_align, int V_align)
	{
		setAlignementHorizontal(H_align);
		setAlignementVertical(V_align);
	}
	
	
	/**
	 * Cree la chaine de caractre  destination de openoffice qui definie ce style
	 * @return la chaine de caractre  crire formate en openoffice.
	 */
	public String toStringOoo()
	{
		String resultat="";
		
		String format="";
		if(formatTexte==FORMAT_NOMBRE_ENTIER)format=" style:parent-style-name=\"Default\" style:data-style-name=\"N3\" ";
		if(formatTexte==FORMAT_NOMBRE_FLOAT)format=" style:parent-style-name=\"Default\" style:data-style-name=\"N5\" ";
		
		
		resultat+="<style:style style:name=\""+getNomStyle()+"\" style:family=\""+getFamilleStyle()+"\" "+format+" >";
		
		resultat+="<style:properties "+getPropriete()+" />";
		resultat+="</style:style>";	
			
		return resultat;
	}
	
	
	private String alignToString()
	{
		String reponse="";
		
		switch(alignV)
		{
			case V_MILIEU:break; //rien c'est par dfaut
			case V_BAS:reponse+=" fo:vertical-align=\"bottom\"";break;
			case V_HAUT:reponse+=" fo:vertical-align=\"top\"";break;
			default: 
				//TODO: Implement 'default' statement
				break;
		}
		
		switch(alignH)
		{
			case H_GAUCHE:break; //rien c'est par dfaut
			case H_CENTRE:reponse+=" fo:text-align=\"center\"";break;
			case H_DROITE:reponse+=" fo:text-align=\"right\"";break;
			default: 
				//TODO: Implement 'default' statement
				break;
		}
		
		return reponse;
		
	}
}
