/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.util.sql;

import java.io.*;
import java.sql.*;


public class ScriptSQL {


	private Connection con;


	public ScriptSQL(Connection con) {
		
		this.con = con;
	}


  public void execute(String script, String base) throws SQLException, IOException {

    String insertBase = "insert into "+ base +".";
    String createBase = "create table "+ base +".";
    String alterBase = "alter table "+ base +".";
    String fromBase = "from "+ base +".";

    String insertRegexp = "insert +into +";
    String createRegexp = "create +table +";
    String alterRegexp = "alter +table +";
    String fromRegexp = "from ";

    Statement stt = con.createStatement();

    BufferedReader br = new BufferedReader(new FileReader(script));

    String ligne;
    String req = "";
		
    while ((ligne = br.readLine()) != null) {
      int id = ligne.indexOf("--");
      if (id == -1) {
        req += ligne.replaceAll(insertRegexp,insertBase).replaceAll(createRegexp,createBase).replaceAll(alterRegexp,alterBase).replaceAll(fromRegexp,fromBase);
      } else {
        req += ligne.substring(0,id).replaceAll(insertRegexp,insertBase).replaceAll(createRegexp,createBase).replaceAll(alterRegexp,alterBase).replaceAll(fromRegexp,fromBase);
      }
			
      if (req.endsWith(";")) {
        stt.execute(req);
        req = "";
      }
    }   
  }

} // fin ScriptSQL
