/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.util.tools;


import java.util.StringTokenizer;


public class StringUtils {

	
	public static String removeHtmlTags(String in) {
		
		if (in.indexOf('<') < 0)
			return in;
		if (in.indexOf('>') < 0)
			return in;
		String s = in;
		boolean startsWithLt = (in.startsWith("<"));
		StringTokenizer st = new StringTokenizer(s, "<");
		StringBuffer b;
		if (startsWithLt)
			b = new StringBuffer();
		else
			b = new StringBuffer(st.nextToken()); //at least 1 token
		while (st.hasMoreTokens()) { //now each token followed a "<"
			String tk = st.nextToken();
			int pos = tk.indexOf('>');
			if (pos < 0)
				b.append(" " + tk);
			else
				b.append(" " + tk.substring(pos + 1));
		}
		return b.toString();
	}
	
	
	/** renvoi l'encodage xml de la string donne en paramtre */
	
	public static String xmlEncode(String str) {
	
		String s = new String(str);
	
		s = s.replaceAll("&", "&amp;");
		s = s.replaceAll("<", "&lt;");
		s = s.replaceAll("'", "&apos;");
		s = s.replaceAll("\"", "&quot;");
	
		return s;
	
		/* %=&#37 ^=&#94 */			
  }
	
	
} // fin StringUtils
