/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *  Mise a jour des informations des articles  l'exception du prix, du stock et du on-line/off-line
 */

package org.opensi.webmanager.fonctions_periodiques;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Vector;

import org.opensi.webmanager.utils.AppelServices;
import org.opensi.webmanager.utils.ArticleFournisseurStruct;
import org.opensi.webmanager.utils.ArticleStruct;
import org.opensi.webmanager.utils.ListeArticleFournisseurStruct;
import org.opensi.webmanager.utils.MultiRapports;
import org.opensi.webmanager.utils.RedactionRapport;
import org.opensi.webmanager.utils.ToolsMAJ;

/**
 * Procdure de mise  jour des informations des articles (description...)
 */
public class MAJInfos {

	private boolean appelServiceReussi;
	private boolean appelToutServiceReussi;
	private boolean noErreurRapport;
	Object[] rapport;
	String dateDebut;
	String dateFin;
	Vector<String> listeId;
	MultiRapports lesRapports;
	private int nbArticlesParEnvoi = 100;
	private int timeout;
	private int nbEchecs;
	private int nbArticles;
	int nbRapports;
	private File aEcrire;
	private String type;

	/**
	 * Prepare le lancement de la mise  jour.
	 * 
	 * @param nbArticles
	 *          nombre d'articles maximum par envoi
	 * @param timeoutService
	 *          temps de rponse maximum du web service
	 * @param lenbRapports
	 *          Nombre de rapports a conserver.
	 */
	public MAJInfos(int nbArticles, int timeoutService, int lenbRapports,String fichier, String nomtype) {
		this(nbArticles,timeoutService,lenbRapports);
		aEcrire = new File(fichier);// le fichier de log
		this.type=nomtype;

	}
	public MAJInfos(int nbArticles, int timeoutService, int lenbRapports) {
		aEcrire = new File("Lancer_Maintenant.log");// le fichier de log
		this.type="";
		appelServiceReussi = true;
		appelToutServiceReussi = true;
		noErreurRapport = true;
		lesRapports = new MultiRapports();

		nbRapports = (lenbRapports > 0)?lenbRapports:10;
		nbArticlesParEnvoi = (nbArticles > 0)?nbArticles:100;
		timeout = (timeoutService >= 0)?timeoutService:20000;
		nbEchecs = 0;
		AppelServices.setTimeout(Integer.valueOf(timeout));
	}
	/**
	 * Lance la mise  jour.
	 * 
	 * La mise  jour est faite en plusieurs tapes: On regarde si il y a des
	 * articles  mettre  jour, puis on cre la liste d'article a envoyer au
	 * serveur, si tout s'est bien pass, on enregistre dans OpenSi que les
	 * informations de ces articles sont maintenant  jour.
	 * 
	 * La connexion  la base de donne n'est ni ouverte ni ferme.
	 * 
	 * @param serveur
	 *          adresse du web service
	 * @param dossierRoot
	 *          chemin absolu vers le seveur de OpenSi (opensi-serveur)
	 * @param dossierId
	 *          identifiant du dossier
	 * @param con
	 *          Connexion  la base de donne
	 * @param base
	 *          Nom de la base de donne FACT_qquechose
	 * @param site_id
	 *          identifiant du site
	 * @return vrai si la mise  jour s'est bien passe, faux sinon.
	 */
	public boolean lancerMAJ(String serveur, String dossierRoot, String dossierId, Connection con, String base, String site_id) {
		java.util.Date date = new java.util.Date();
		Timestamp stamp = new Timestamp(date.getTime());
		dateDebut = "" + stamp;

		appelService(serveur, con, base, site_id);

		date = new java.util.Date();
		stamp = new Timestamp(date.getTime());
		dateFin = "" + stamp;

		try {

			String requete = "UPDATE " + base + ".MAJ_AUTO SET Derniere_Maj=" + date.getTime() + " WHERE Site_Id=" + site_id
			+ " AND Type_Maj='INFO'";
			Statement state = con.createStatement();
			state.executeUpdate(requete);
		}
		catch (Exception e) {
			e.printStackTrace();
		}

		ecrireRapport(dossierRoot, dossierId, site_id);

		return appelToutServiceReussi;

	}

	/**
	 * Envoie les informations au web service
	 */
	private void appelService(String serveur, Connection con, String base, String site_id) {
		try {
			// On rcupre toutes les infos  l'exception du stock et du prix et
			// de on-line/off-line

			String reqInfo = "";
			reqInfo += "SELECT w.Article_Id, w.Article_Web_Id,w.Article_Id_Site, fa1.Libelle as Famille_1, coalesce(fa2.Libelle,'') as Famille_2, coalesce(ma.Libelle,'') as Marque, f.Designation, coalesce(ca.Libelle,'') as Couleur, coalesce(ta.Libelle,'') as Taille, t.Taux_TVA";
			reqInfo += ", f.Descrip_1, if(f.Mesure_Poids='K',f.Poids_Brut,if(f.Mesure_Poids='G',f.Poids_Brut/1000,f.Poids_Brut*1000)) as Poids_Brut, f.Date_M, coalesce(cca.Libelle,'') as Collection, Ref_Fabricant";
			reqInfo += " FROM " + base + ".FICHE_ARTICLE_WEB w, " + base + ".FICHE_ARTICLE f, "+ base + ".TAUX_TVA t, "+ base +".FAMILLE_ARTICLE fa1";
			reqInfo += " left join "+ base +".FAMILLE_ARTICLE fa2 on f.Famille_2=fa2.Famille_Id";
			reqInfo += " left join "+ base +".MARQUE_ARTICLE ma on f.Marque_Id=ma.Marque_Id";
			reqInfo += " left join "+ base +".COULEUR_ARTICLE ca on f.Couleur_Id=ca.Couleur_Id";
			reqInfo += " left join "+ base +".TAILLE_ARTICLE ta on f.Taille_Id=ta.Taille_Id";
			reqInfo += " left join "+ base +".COLLECTION_ARTICLE cca on f.Collection_Id=cca.Collection_Id";
			reqInfo += " WHERE f.Famille_1=fa1.Famille_Id and w.Date_Info_Ref<f.Date_M AND f.Article_Id=w.Article_Id AND f.Code_TVA=t.Code_TVA AND w.Site_Id=" + site_id;


			String reqFour = "SELECT Fournisseur_Id,Article_Id,Ref_Fournisseur ";
			reqFour += " FROM " + base + ".FOURNISSEUR_ARTICLE fa ";
			reqFour += " WHERE Article_Id=?";
			PreparedStatement ps3 = con.prepareStatement(reqFour);

			Statement state = con.createStatement();
			ResultSet resInfo = state.executeQuery(reqInfo);

			Vector<Object> liste = new Vector<Object>();
			listeId = new Vector<String>();

			int compteur = 0;
			while (resInfo.next()) {
				ArticleStruct articleTemp = new ArticleStruct();
				articleTemp.setString(articleTemp.REFERENCE,"" + resInfo.getString("Article_Id_Site"));
				articleTemp.setString(articleTemp.DESIGNATION,resInfo.getString("Designation"));
				articleTemp.setString(articleTemp.DESCRIPTION,resInfo.getString("Descrip_1"));
				articleTemp.setString(articleTemp.MARQUE,resInfo.getString("Marque"));
				articleTemp.setString(articleTemp.FAMILLE,resInfo.getString("Famille_1"));
				articleTemp.setString(articleTemp.SOUS_FAMILLE,resInfo.getString("Famille_2"));
				articleTemp.setDouble(articleTemp.POIDS,resInfo.getDouble("Poids_Brut"));
				articleTemp.setDouble(articleTemp.TVA,resInfo.getDouble("Taux_TVA"));
				articleTemp.setString(articleTemp.COULEUR,resInfo.getString("Couleur"));
				articleTemp.setString(articleTemp.TAILLE,resInfo.getString("Taille"));
				articleTemp.setString(articleTemp.COLLECTION,resInfo.getString("Collection"));
				articleTemp.setString(articleTemp.REFERENCE_FABRICANT,resInfo.getString("Ref_Fabricant"));        

				ps3.setString(1, resInfo.getString("Article_Id_Site"));
				ResultSet results3 = ps3.executeQuery();
				ListeArticleFournisseurStruct listeArticleFournisseur=new ListeArticleFournisseurStruct();
				System.out.println("----------------");
				while(results3.next()) {
					ArticleFournisseurStruct article=new ArticleFournisseurStruct();
					article.setString(article.REFERENCE,results3.getString("Article_Id"));
					article.setString(article.FOURNISSEUR,results3.getString("Fournisseur_Id"));
					article.setString(article.REFERENCE_FOURNISSEUR,results3.getString("Ref_Fournisseur"));

					listeArticleFournisseur.addArticle(article);
				}
				articleTemp.setStruct(articleTemp.LISTE_REFERENCE_FOURNISSEUR,listeArticleFournisseur.getListeStruct());				

				liste.add(articleTemp.getStruct());

				listeId.add(resInfo.getString("Article_Id"));

				// On envoi tout les nbArticlesParEnvoi articles
				if ((compteur % nbArticlesParEnvoi) == 0 && compteur > 0) {
					ToolsMAJ.ecrireLog(aEcrire,type,"[MAJInfos(appelService)] Appel du service pour " + nbArticlesParEnvoi + " articles.");
					envoyerMaj(serveur, liste.toArray());

					appelToutServiceReussi &= appelServiceReussi;

					if (appelServiceReussi) {
						ToolsMAJ.ecrireLog(aEcrire,type,"[MAJInfos(appelService)] Je valide ");
						validerDansOpenSi(con, base, site_id);
					}
					else {
						nbEchecs += nbArticlesParEnvoi;
					}

					liste = new Vector<Object>();
					listeId = new Vector<String>();// pour valider
				}
				compteur++;

			}

			nbArticles = compteur;

			// la fin de la liste
			if (nbArticles > 0) {
				ToolsMAJ.ecrireLog(aEcrire,type,"[MAJInfos(appelService)] Appel du service pour " + nbArticlesParEnvoi + " articles.");
				envoyerMaj(serveur, liste.toArray());

				if (appelServiceReussi) {
					ToolsMAJ.ecrireLog(aEcrire,type,"[MAJInfos(appelService)] Je valide ");
					validerDansOpenSi(con, base, site_id);
				}
				else {
					nbEchecs += nbArticlesParEnvoi;
				}
			}

		}
		catch (Exception e) {
			ToolsMAJ.ecrireLog(aEcrire,type,"[MAJInfos(appelService)] ERREUR " + e);
		}

	}

	private void envoyerMaj(String serveur, Object[] liste) {

		appelServiceReussi = true;

		try {
			Object resultat = AppelServices.majInfos(serveur, liste);
			Object[] rep = (Object[]) resultat;
			Object[] rapport = (Object[]) rep[0];
			lesRapports.addRapport(rapport);
		}
		catch (Exception e) {
			ToolsMAJ.ecrireLog(aEcrire,type,"[MAJInfos(envoyerMaj)] ERREUR:" + e);
			appelServiceReussi = false;
		}

	}

	/*
	 * Ecris un rapport dans dossierRoot/rapport/dossierId
	 */

	private void ecrireRapport(String dossierRoot, String dossierId, String site_id) {

		try {
			RedactionRapport ecriveur = new RedactionRapport(ToolsMAJ.TYPE_MAJ_INFO, nbRapports, dossierRoot, dossierId, site_id);

			ecriveur.ajouterLigne(dateDebut + ":La mise a jour des dtails a t lance", true);
			if (nbArticles > 0) {
				if (!appelToutServiceReussi) {
					ecriveur.ajouterLigne("\nUne erreur s'est produite.", false);
				}

				String lesDetails = "";

				int cptErreur = 0;
				int cptOk = 0;

				while (lesRapports.next()) {
					if (lesRapports.aReussi()) {
						lesDetails += "\n<br>" + lesRapports.getMessageUtilisateur();
						cptOk++;
					}
					else {
						lesDetails += "\n<br><span class=\"echec\">" + lesRapports.getMessageUtilisateur() + "</span>";
						cptErreur++;
					}

					noErreurRapport = noErreurRapport && (lesRapports.aReussi());
				}

				if (noErreurRapport && nbEchecs == 0) {
					ecriveur.ajouterLigne(dateFin + ":Tous les dtails ont t mis a jour", true);
				}
				else {
					ecriveur.ajouterLigne(dateFin + ":" + nbEchecs + " articles n'ont pas t mis a jour sur " + nbArticles + ".", false);
					ecriveur.ajouterLigne(dateFin + ":Fin de la transmission.", true);
				}

				if (!lesDetails.equals("")) {
					ecriveur.ajouterLigne(" ****************** DETAILS **************", true);
					ecriveur.ajouterLigne(lesDetails, true);
				}
			}
			else {
				ecriveur.ajouterLigne("Pas d'articles a mettre  jour", true);
			}

			ecriveur.fermerFichier();

		}
		catch (java.io.IOException e) {
			ToolsMAJ.ecrireLog(aEcrire,type,"[MAJInfos(ecrireRapport)] ERREUR:" + e);
		}

	}

	/*
	 * Valide la mise  jour dans OpenSi: change la date de rfrence info par
	 * celle de l'article utilise prcedemment
	 */
	private void validerDansOpenSi(Connection con, String base, String site_id) {
		try {

			String listeId_str = "";

			if (listeId.size() > 0) {
				listeId_str += "'" + ToolsMAJ.sqlEncode(listeId.elementAt(0)) + "'";
			}

			for (int i = 1; i < listeId.size(); i++) {
				listeId_str += ",'" + ToolsMAJ.sqlEncode(listeId.elementAt(i)) + "'";
			}

			String req = "UPDATE " + base + ".FICHE_ARTICLE_WEB w, " + base + ".FICHE_ARTICLE a SET w.Date_Info_Ref=a.Date_M ";
			req += " WHERE a.Article_Id=w.Article_Id AND w.Article_Id IN(" + listeId_str + ") AND Site_Id=" + site_id;

			ToolsMAJ.ecrireLog(aEcrire,type,"La requete:" + req);

			Statement state = con.createStatement();
			state.executeUpdate(req);

		}
		catch (Exception e) {
			ToolsMAJ.ecrireLog(aEcrire,type,"[MAJInfos(validerDansOpenSi)] ERREUR " + e);
		}
	}
}
