/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *  Mise a jour du stock
 */

package org.opensi.webmanager.fonctions_periodiques;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Vector;

import org.opensi.webmanager.utils.AppelServices;
import org.opensi.webmanager.utils.MultiRapports;
import org.opensi.webmanager.utils.RedactionRapport;
import org.opensi.webmanager.utils.ToolsMAJ;

/**
 * Procdure de mise  jour des stocks
 */
public class MAJStock {

	private boolean appelServiceReussi;
	private boolean appelToutServiceReussi;
	private boolean noErreurRapport;
	String dateDebut;
	String dateFin;
	int nbArticlesParEnvoi = 100;
	MultiRapports lesRapports;
	private int timeout;
	private int nbEchecs;
	private int nbArticles;
	private int nbRapports;
	Vector<String> listeId;
	private File aEcrire;
	private String type;

	/**
	 * Prpare la mise  jour des stocks.
	 * 
	 * @param nbArticles
	 *          nombre d'article maximum par envoi
	 * @param timeoutService
	 *          timeout en milisecondes
	 * @param lenbRapports
	 *          nombre de rapport  conserver
	 */
	public MAJStock(int nbArticles, int timeoutService, int lenbRapports,String fichier, String nomtype) {
		this(nbArticles,timeoutService,lenbRapports);
		aEcrire = new File(fichier);// le fichier de log
		this.type=nomtype;
	}
	public MAJStock(int nbArticles, int timeoutService, int lenbRapports) {
		aEcrire = new File("Lancer_Maintenant.log");// le fichier de log
		this.type="";
		appelServiceReussi = true;
		appelToutServiceReussi = true;
		noErreurRapport = true;
		lesRapports = new MultiRapports();

		nbRapports = (lenbRapports > 0)?lenbRapports:10;
		nbArticlesParEnvoi = (nbArticles > 0)?nbArticles:100;
		timeout = (timeoutService >= 0)?timeoutService:20000;
		nbEchecs = 0;
		AppelServices.setTimeout(new Integer(timeout));
	}

	/**
	 * Lance la mise  jour.
	 * 
	 * La connexion  la base de donne n'est ni ouverte ni ferme.
	 * 
	 * @param serveur
	 *          adresse du web service
	 * @param dossierRoot
	 *          chemin absolu vers le seveur de OpenSi (opensi-serveur)
	 * @param dossierId
	 *          identifiant du dossier
	 * @param con
	 *          Connexion  la base de donne
	 * @param base
	 *          Nom de la base de donne FACT_qquechose
	 * @param site_id
	 *          identifiant du site
	 * @return vrai si la mise  jour s'est bien passe, faux sinon.
	 */
	public boolean lancerMAJ(String serveur, String dossierRoot, String dossierId, Connection con, String base, String site_id) {
		ToolsMAJ.ecrireLog(aEcrire,type,"Debut de lancerMaj");

		java.util.Date date = new java.util.Date();
		Timestamp stamp = new Timestamp(date.getTime());
		dateDebut = "" + stamp;

		appelService(serveur, con, base, site_id);

		date = new java.util.Date();
		stamp = new Timestamp(date.getTime());
		dateFin = "" + stamp;

		try {
			String requete = "UPDATE " + base + ".MAJ_AUTO SET Derniere_Maj=" + date.getTime() + " WHERE Site_Id=" + site_id
					+ " AND Type_Maj='STOCK'";
			Statement state = con.createStatement();
			state.executeUpdate(requete);
		}
		catch (Exception e) {
			e.printStackTrace();
		}
		ecrireRapport(dossierRoot, dossierId, site_id);

		return appelToutServiceReussi;
	}

	private void appelService(String serveur, Connection con, String base, String site_id) {
		try {
			ToolsMAJ.ecrireLog(aEcrire,type,"Je calcule les caracs");

			String reqStock = "SELECT faw.Article_Web_Id,faw.Article_Id_Site, faw.Stock_Web, faw.Article_Id, (Stock_Init+Entrees-Sorties-Com_Clients) as Stock_Dispo FROM " + base + ".FICHE_ARTICLE_WEB faw," + base + ".STOCKS_ARTICLE sa ";
			reqStock += " WHERE Ancien_Stock!=(Stock_Init+Entrees-Sorties-Com_Clients) AND Site_Id=" + site_id+" and faw.Article_Id=sa.Article_Id";
			Statement state = con.createStatement();
			ResultSet resStock = state.executeQuery(reqStock);

			Vector<Object[]> liste = new Vector<Object[]>();
			listeId = new Vector<String>();

			int compteur = 0;

			String reqSuppr="UPDATE " + base + ".FICHE_ARTICLE_WEB SET Ancien_Stock=? WHERE Article_Id=?";
			PreparedStatement psDel = con.prepareStatement(reqSuppr);

			while (resStock.next()) {
				ToolsMAJ.ecrireLog(aEcrire,type,"Je loope");
				Object[] id_stock = new Object[2];
				id_stock[0] = new Integer(resStock.getInt("Stock_Dispo"));
				id_stock[1] = new String(resStock.getString("Article_Id_Site"));

				liste.add(id_stock);
				listeId.add(resStock.getString("Article_Id"));
				// On envoi tout les nbArticlesParEnvoi articles
				if ((compteur % nbArticlesParEnvoi) == 0 && compteur > 0) {
					ToolsMAJ.ecrireLog(aEcrire,type,"Appel du service pour " + nbArticlesParEnvoi + " articles.");
					envoyerMaj(serveur, liste.toArray());

					appelToutServiceReussi &= appelServiceReussi;

					if (appelServiceReussi) {
						ToolsMAJ.ecrireLog(aEcrire,type,"Je valide ");
						validerDansOpenSi(con, base, site_id);
					}
					else {
						ToolsMAJ.ecrireLog(aEcrire,type,"ECHEC DE L'APPEL");
						nbEchecs += nbArticlesParEnvoi;
					}

					liste = new Vector<Object[]>();
					listeId = new Vector<String>();// pour valider
				}
				compteur++;

				psDel.setInt(1,resStock.getInt("Stock_Dispo"));
				psDel.setString(2,""+resStock.getString("Article_Id"));
				psDel.addBatch();
			}
			psDel.executeBatch();
			
			nbArticles = compteur;
			// la fin de la liste
			if (nbArticles > 0) {
				ToolsMAJ.ecrireLog(aEcrire,type,"Appel du service pour " + nbArticles + " articles.");
				envoyerMaj(serveur, liste.toArray());

				if (appelServiceReussi) {
					ToolsMAJ.ecrireLog(aEcrire,type,"Je valide ");
					validerDansOpenSi(con, base, site_id);
				}
				else {
					ToolsMAJ.ecrireLog(aEcrire,type,"ECHEC");
					nbEchecs += nbArticlesParEnvoi;
				}
			}

			ToolsMAJ.ecrireLog(aEcrire,type,"Fin de lancerMaj");

		}
		catch (Exception e) {
			ToolsMAJ.ecrireLog(aEcrire,type,"[MAJStock(appelService)] ERREUR " + e);
		}

	}

	private void envoyerMaj(String serveur, Object[] liste) {
		appelServiceReussi = true;

		try {
			Object resultat = AppelServices.majStocks(serveur, liste);
			Object[] rep = (Object[]) resultat;

			Object[] rapport = (Object[]) rep[0];

			lesRapports.addRapport(rapport);

		}
		catch (Exception e) {
			ToolsMAJ.ecrireLog(aEcrire,type,"[MAJStock(appelServices)] ERREUR:" + e);
			appelServiceReussi = false;
		}

	}

	private void ecrireRapport(String dossierRoot, String dossierId, String site_id) {

		try {
			RedactionRapport ecriveur = new RedactionRapport(ToolsMAJ.TYPE_MAJ_STOCKS, nbRapports, dossierRoot, dossierId, site_id);

			ecriveur.ajouterLigne(dateDebut + ":La mise a jour des stock a t lance", true);
			if (nbArticles > 0) {
				if (!appelToutServiceReussi) {
					ecriveur.ajouterLigne("\nUne erreur s'est produite.", false);
				}

				String lesDetails = "";

				int cptErreur = 0;
				int cptOk = 0;

				while (lesRapports.next()) {
					if (lesRapports.aReussi()) {
						lesDetails += "\n<br>" + lesRapports.getMessageUtilisateur();
						cptOk++;
					}
					else {
						lesDetails += "\n<br><span class=\"echec\">" + lesRapports.getMessageUtilisateur() + "</span>";
						cptErreur++;
					}

					noErreurRapport = noErreurRapport && (lesRapports.aReussi());
				}

				if (noErreurRapport && nbEchecs == 0) {
					ecriveur.ajouterLigne(dateFin + ":Tous les stocks ont t mis a jour", true);
				}
				else {
					ecriveur.ajouterLigne(dateFin + ":" + nbEchecs + " articles n'ont pas t mis a jour sur " + nbArticles + ".", false);
					ecriveur.ajouterLigne(dateFin + ":Fin de la transmission.", true);
				}

				if (!lesDetails.equals("")) {
					ecriveur.ajouterLigne(" ****************** DETAILS **************", true);
					ecriveur.ajouterLigne(lesDetails, true);
				}
			}
			else {
				ecriveur.ajouterLigne("Pas d'articles a mettre  jour", true);
			}

			ecriveur.fermerFichier();

		}
		catch (java.io.IOException e) {
			ToolsMAJ.ecrireLog(aEcrire,type,"[MAJStock(ecrireRapport)] ERREUR:" + e);
		}

	}

	private void validerDansOpenSi(Connection con, String base, String site_id) {
		try {

			String listeId_str = "";

			if (listeId.size() > 0) {
				listeId_str += "'" + ToolsMAJ.sqlEncode("" + listeId.elementAt(0)) + "'";
			}

			for (int i = 1; i < listeId.size(); i++) {
				listeId_str += ",'" + ToolsMAJ.sqlEncode("" + listeId.elementAt(i)) + "'";
			}

			String req = "UPDATE " + base + ".FICHE_ARTICLE_WEB SET Stock_Modifie=0 WHERE Site_Id=" + site_id;
			req += " AND Article_Id IN (" + listeId_str + ")";

			Statement state = con.createStatement();
			state.executeUpdate(req);
		}
		catch (Exception e) {
			ToolsMAJ.ecrireLog(aEcrire,type,"[MAJStock(validerDansOpenSi)] ERREUR " + e);
		}
	}
}
