/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *  Rcupration des clients
 */

package org.opensi.webmanager.fonctions_periodiques;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;

import org.opensi.webmanager.utils.AppelServices;
import org.opensi.webmanager.utils.ClientStruct;
import org.opensi.webmanager.utils.MultiRapports;
import org.opensi.webmanager.utils.PersonneStruct;
import org.opensi.webmanager.utils.RedactionRapport;
import org.opensi.webmanager.utils.ToolsMAJ;

/**
 * Procdure de rcupration des clients.
 */
public class UploadClients {

	boolean appelServiceReussi;
	boolean appelToutServiceReussi;
	Object[] rapport;
	String dateDebut;
	String dateFin;
	Object[] listeClients;
	int nbRecupReussi;
	MultiRapports lesRapports;
	HashMap<Double, Integer> code_tva;
	int nbClients;
	private File aEcrire;
	private String type;

	/**
	 * Initialise la rcupration des clients.
	 */
	public UploadClients(String nomFichier, String nomtype) {
		this();
		aEcrire = new File(nomFichier);// le fichier de log
		this.type=nomtype;
	}
	public UploadClients() {
		aEcrire = new File("Lancer_Maintenant.log");// le fichier de log
		this.type="";
		appelServiceReussi = true;
		lesRapports = new MultiRapports();
	}

	/**
	 * Lance la rcupration des clients.
	 * 
	 * La connexion  la base de donne n'est ni ouverte ni ferme.
	 * 
	 * @param serveur
	 *          adresse du web service
	 * @param dossierRoot
	 *          chemin absolu vers le seveur de OpenSi (opensi-serveur)
	 * @param dossierId
	 *          identifiant du dossier
	 * @param con
	 *          Connexion  la base de donne
	 * @param nomBase
	 *          Nom de la base de donne FACT_qquechose
	 * @param site_id
	 *          identifiant du site
	 * @return vrai si la mise  jour s'est bien passe, faux sinon.
	 */
	public boolean lancerUpload(String serveur, String dossierRoot, String dossierId, Connection con, String nomBase, String site_id) {
		// //ToolsMAJ.ecrireLog(aEcrire,type,"[UploadClients] Debut ");

		nbRecupReussi = 0;
		nbClients = 0;
		appelToutServiceReussi = true;
		java.util.Date date = new java.util.Date();
		Timestamp stamp = new Timestamp(date.getTime());
		dateDebut = "" + stamp;

		boolean continuer = true;

		// Pour la gestion des codes de TVA
		code_tva = new HashMap<Double, Integer>();
		try {
			String req = "SELECT Code_TVA, Taux_TVA from " + nomBase + ".TAUX_TVA";
			Statement state = con.createStatement();
			ResultSet resTva = state.executeQuery(req);

			while (resTva.next()) {
				code_tva.put(new Double(resTva.getDouble("Taux_Tva")), new Integer(resTva.getInt("Code_TVA")));
			}
		}
		catch (Exception e) {
			ToolsMAJ.ecrireLog(aEcrire,type,"[UploadClients] ERREUR1:" + e);
		}

		while (continuer) {
			appelServiceReussi = true;

			continuer = appelService(serveur);
			appelToutServiceReussi = appelToutServiceReussi && appelServiceReussi;
			if (appelServiceReussi) {

				enregistrer(con, nomBase, site_id);
				nbRecupReussi++;
			}

		}

		date = new java.util.Date();
		stamp = new Timestamp(date.getTime());
		dateFin = "" + stamp;

		try {
			String requete = "UPDATE " + nomBase + ".MAJ_AUTO SET Derniere_Maj=" + date.getTime() + " WHERE Site_Id=" + site_id
					+ " AND Type_Maj='CLI'";
			Statement state = con.createStatement();
			state.executeUpdate(requete);
		}
		catch (Exception e) {
			ToolsMAJ.ecrireLog(aEcrire,type,"[UploadClient]ERREUR2" + e);
		}

		ecrireRapport(dossierRoot, dossierId, site_id);

		// ToolsMAJ.ecrireLog(aEcrire,type,"[UploadClients] Fin ");

		return appelToutServiceReussi;

	}

	private boolean appelService(String serveur) {

		ToolsMAJ.ecrireLog(aEcrire,type,"[UploadClients] Appel du service");
		Object resultat = null;
		boolean resultFct = false;

		try {
			ToolsMAJ.ecrireLog(aEcrire,type,"[UploadClients] 1.Appel du web service");
			resultat = AppelServices.uploadClients(serveur);
			ToolsMAJ.ecrireLog(aEcrire,type,"[UploadClients] 1.1 fin Appel du web service");

			Object[] rep = (Object[]) resultat; // valeur
			Object[] rapport = (Object[]) rep[0];// rapport

			ToolsMAJ.ecrireLog(aEcrire,type,"[UploadClients] 2.Recup du rapport");
			lesRapports.addRapport(rapport);

			Object[] listeCliPlusBool = (Object[]) rep[1];

			ToolsMAJ.ecrireLog(aEcrire,type,"[UploadClients] 3.Recup des valeurs de retour");
			// Je sais que c'est une liste de clients
			listeClients = (Object[]) listeCliPlusBool[0];

			ToolsMAJ.ecrireLog(aEcrire,type,"[UploadClients] 4.Recup du boolean");
			// Boolen indiquant si il faut continuer ou non
			Boolean fautContinuer = (Boolean) listeCliPlusBool[1];
			if (fautContinuer == null) {
				resultFct = false;
				appelServiceReussi = false;
			}
			else {
				ToolsMAJ.ecrireLog(aEcrire,type,"[UploadClients] 5.Affichage :" + fautContinuer);
				resultFct = ((Boolean) listeCliPlusBool[1]).booleanValue() && listeClients.length>0;
			}
		}
		catch (Exception e) {
			ToolsMAJ.ecrireLog(aEcrire,type,"[UploadClients] ERREUR:" + e);
			appelServiceReussi = false;
		}

		return resultFct;

	}

	private void ecrireRapport(String dossierRoot, String dossierId, String site_id) {

		try {
			boolean noErreurRapport = true;
			RedactionRapport ecriveur = new RedactionRapport(ToolsMAJ.TYPE_UPLOAD_CLIENTS, 10, dossierRoot, dossierId, site_id);

			ecriveur.ajouterLigne(dateDebut + ":La rcupration des clients a t lance", true);

			if (nbRecupReussi < 1) {
				ecriveur.ajouterLigne("\nLe site distant n'a pas pu tre atteint. Aucun client rcupr.", false);
			}
			else {
				// ToolsMAJ.ecrireLog(aEcrire,type,"[UploadClient] Nb de clients:"+nbClients);

				// if(nbClients==0)
				// {
				// ecriveur.ajouterLigne(dateFin+":Aucune nouvelle
				// client.",true);
				// }
				// else
				// {

				String lesDetails = "";

				int cptErreur = 0;
				int cptOk = 0;

				while (lesRapports.next()) {
					if (lesRapports.aReussi()) {
						lesDetails += "\n<br>" + lesRapports.getMessageUtilisateur();
						cptOk++;
					}
					else {
						lesDetails += "\n<br><span class=\"echec\">" + lesRapports.getMessageUtilisateur() + "</span>";
						cptErreur++;
					}

					noErreurRapport = noErreurRapport && (lesRapports.aReussi());
				}

				if (cptErreur >= 0) {
					ecriveur.ajouterLigne(dateFin + ":Tous les clients ont t rcuprs", true);
				}
				else {
					ecriveur.ajouterLigne(dateFin + ":" + cptErreur + " clients n'ont pas t rcuprs.", false);
					ecriveur.ajouterLigne(dateFin + ":" + cptOk + " clients ont t rcuprs.", true);
				}

				if (!lesDetails.equals("")) {
					ecriveur.ajouterLigne(" ****************** DETAILS **************", true);
					ecriveur.ajouterLigne(lesDetails, true);
				}
				// }

			}

			ecriveur.fermerFichier();

		}
		catch (java.io.IOException e) {
			ToolsMAJ.ecrireLog(aEcrire,type,"[UploadClients(ecrireRapport)] ERREUR4:" + e);
		}

	}

	/* *********************************************************************** */
	/* * Enregistrement dans la base * */
	/* *********************************************************************** */

	private void enregistrer(Connection con, String base, String site_id) {
		try {
			ToolsMAJ.ecrireLog(aEcrire,type,"[UploadClients] Enregistrement");

			nbClients += listeClients.length;

			for (int j = 0; j < listeClients.length; j++) {

				ClientStruct client = new ClientStruct((Object[]) listeClients[j]);
				PersonneStruct personneClient = new PersonneStruct(client.getStruct(client.PERSONNE));

				String client_id=client.getString(client.ID,60);
				String client_civ=personneClient.getString(personneClient.CIV,1);
				String client_nom=personneClient.getString(personneClient.NOM,30);
				String client_prenom=personneClient.getString(personneClient.PRENOM,30);
				String client_entreprise=personneClient.getString(personneClient.ENTREPRISE,50);
				String client_adresse=personneClient.getString(personneClient.ADRESSE,80);
				String client_compadresse=personneClient.getString(personneClient.COMPADRESSE,50);
				String client_adresse3=personneClient.getString(personneClient.ADRESSE3,50);
				String client_cp=personneClient.getString(personneClient.CP,10);
				String client_ville=personneClient.getString(personneClient.VILLE,50);
				String client_code_pays=personneClient.getString(personneClient.CODE_PAYS,3);
				String client_tel=client.getString(client.TEL,20);
				String client_fax=client.getString(client.FAX,20);
				String client_email=client.getString(client.EMAIL,64);
				String client_pass=client.getString(client.PASS,20);

				String fact_civ_string="";
				String reqCiv = "SELECT * FROM CIVILITE WHERE Civ_Id="+ client_civ;
				PreparedStatement psCiv = con.prepareStatement(reqCiv);
				ResultSet resCiv = psCiv.executeQuery();
				if (resCiv.next()) {
					fact_civ_string=resCiv.getString("Civ_Courte");
				}
				String clientDenomination = client_entreprise.equals("")?fact_civ_string +((fact_civ_string.equals(""))?"":" ")+client_nom+" "+client_prenom:client_entreprise;

				String insertup = "insert into " + base + ".CLIENT_WEB ";
				insertup +=	"(Client_Site_Id,Site_Id,Civ,Nom,Prenom,Entreprise,Adresse_1, Adresse_2,Adresse_3, Code_Postal,Ville,Code_Pays,Tel,Fax,Email,Password) ";
				insertup +=	"values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,lcase(?),?) ";
				insertup +=	"on duplicate key update Civ=?,Nom=?,Prenom=?,Entreprise=?,Adresse_1=?, Adresse_2=?,Adresse_3=?, Code_Postal=?,Ville=?,Code_Pays=?,Tel=?,Fax=?,Email=lcase(?),Password=?;";
				PreparedStatement psinsertup = con.prepareStatement(insertup);

				psinsertup.setString(1, client_id);
				psinsertup.setString(2, site_id);
				if (client_entreprise.equals("")) {
					psinsertup.setString(3, "0");
					psinsertup.setString(4, "");
					psinsertup.setString(5, "");
					psinsertup.setString(6, clientDenomination);
				}
				else {
					psinsertup.setString(3, client_civ);
					psinsertup.setString(4, client_nom);
					psinsertup.setString(5, client_prenom);
					psinsertup.setString(6, clientDenomination);
				}

				psinsertup.setString(7, client_adresse);
				psinsertup.setString(8, client_compadresse);
				psinsertup.setString(9, client_adresse3);
				psinsertup.setString(10, client_cp);
				psinsertup.setString(11, client_ville);
				psinsertup.setString(12, client_code_pays);
				psinsertup.setString(13, client_tel);
				psinsertup.setString(14, client_fax);
				psinsertup.setString(15, client_email);
				psinsertup.setString(16, client_pass);

				if (client_entreprise.equals("")) {
					psinsertup.setString(17, "0");
					psinsertup.setString(18, "");
					psinsertup.setString(19, "");
					psinsertup.setString(20, clientDenomination);
				}
				else {
					psinsertup.setString(17, client_civ);
					psinsertup.setString(18, client_nom);
					psinsertup.setString(19, client_prenom);
					psinsertup.setString(20, clientDenomination);
				}
				psinsertup.setString(21, client_adresse);
				psinsertup.setString(22, client_compadresse);
				psinsertup.setString(23, client_adresse3);
				psinsertup.setString(24, client_cp);
				psinsertup.setString(25, client_ville);
				psinsertup.setString(26, client_code_pays);
				psinsertup.setString(27, client_tel);
				psinsertup.setString(28, client_fax);
				psinsertup.setString(29, client_email);	
				psinsertup.setString(30, client_pass);
				psinsertup.executeUpdate();

			}
		}
		catch (Exception e) {
			ToolsMAJ.ecrireLog(aEcrire,type,"[UploadClients] ERREUR5:" + e);
			e.printStackTrace();
		}
	}

}
