/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *  Requetes multiples d'insertion ou de suppression d'articles web.
 */

package org.opensi.webmanager.init_vente;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;

public class AjoutSupprGroupeArticlesWeb extends Action {

	public boolean serverSide() {
		return true;
	}

	/**
	 * 
	 * @param s
	 * @param r
	 * @param info
	 * @throws java.lang.Exception
	 * @return boolean
	 */
	public boolean service(Session s, ServletRequest r, Object info) throws Exception {

		String famille1 = r.getParameter("famille1");
		String famille2 = r.getParameter("famille2");
		String base = r.getParameter("base");
		String site_id = r.getParameter("site_id");
		String modeOp = r.getParameter("modeOp");

		Connection con = s.getConnection(null);

		if (modeOp.equals("DEL") && famille1.equals("")) {// facile

			String reqDel = "DELETE FROM " + base + ".FICHE_ARTICLE_WEB WHERE";
			reqDel += " Site_Id='" + site_id + "'";

			Statement state = con.createStatement();
			state.executeUpdate(reqDel);
		}
		else {
			String condSousFam = "";
			String condFam = "";

			if (famille1.equals("")) {
				condFam = "";
			}
			else {// Si il y a une sous famille, il doit y avoir une famille
				condFam = " and Famille_1=" + famille1;

				if (!famille2.equals("")) {
					condSousFam = " AND Famille_2=" + famille2;
				}
			}

			String reqListeID = "SELECT Article_Id, Date_M FROM " + base + ".FICHE_ARTICLE where Supprime=0  " + condFam + condSousFam;

			String reqMultiple = "";

			if (modeOp.equals("CREER")) {
				reqMultiple = "INSERT INTO ";
				reqMultiple += base + ".FICHE_ARTICLE_WEB (Article_Id,Site_Id,Etat_Existance) VALUES ";
				reqMultiple += "( ?, '" + site_id + "',1)";
			}
			else if (modeOp.equals("DEL")) {
				reqMultiple = "DELETE FROM ";
				reqMultiple += base + ".FICHE_ARTICLE_WEB WHERE Site_Id='" + site_id + "'";
				reqMultiple += " AND Article_Id=?";
			}

			Statement state = con.createStatement();
			PreparedStatement ps = con.prepareStatement(reqMultiple);

			ResultSet resultSet = state.executeQuery(reqListeID);

			while (resultSet.next()) {
				ps.setString(1, resultSet.getString("Article_Id"));
				ps.addBatch();
			}
			ps.executeBatch();

		}

		s.closeConnection(con, null);

		return true;

	}

}
