/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *  Publication des articles
 */

package org.opensi.webmanager.init_vente;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.webmanager.fonctions_periodiques.MAJArticles;
import org.opensi.webmanager.utils.AppelServices;
import org.opensi.webmanager.utils.CalculCaracsWeb;

/**
 * Envoi tous les articles sur le site
 */
public class Publication extends Action {

	boolean publicationReussie;
	boolean imagesArticlesReussie;
	boolean imagesFamilleReussie;
	boolean imagesSousFamilleReussie;
	boolean imagesMarqueReussie;
	int nbArticlesParEnvoi = 100;

	/**
	 * 
	 * @return
	 */
	public boolean serverSide() {
		return true;
	}

	/**
	 * 
	 * @param s
	 * @param r
	 * @param info
	 * @throws java.lang.Exception
	 * @return
	 */
	public boolean service(Session s, ServletRequest r, Object info) throws Exception {

		publicationReussie = true;
		imagesArticlesReussie = true;
		imagesFamilleReussie = true;
		imagesSousFamilleReussie = true;
		imagesMarqueReussie = true;

		String base = r.getParameter("base");
		String site_id = r.getParameter("site_id");
		String dossierServeur = s.getAppConfiguration().get("opensi.absdir");
		String dossier_id = r.getParameter("dossier_id");
		String nbParEnvoi_str = s.getAppConfiguration().get("weblink.maxitem");
		String timeout_str = s.getAppConfiguration().get("weblink.timeout");
		String rapport_str = s.getAppConfiguration().get("weblink.nbrapports");
		int nbRapports = Integer.parseInt(rapport_str);
		int nbParEnvoi = Integer.parseInt(nbParEnvoi_str);
		int timeout = Integer.parseInt(timeout_str);

		Connection con = s.getConnection(null);
		Statement state = con.createStatement();

		String requeteParamServeur = "SELECT URL_Service";
		requeteParamServeur += " FROM " + base + ".SITE_WEB WHERE Site_Id='" + site_id + "'";

		ResultSet resultSet = state.executeQuery(requeteParamServeur);

		String url_serveur = "";

		// ------------------------------------------------
		// Recalcul des prix Web
		// ------------------------------------------------
		CalculCaracsWeb.calculPrix(con, base, site_id);

		if (resultSet.next()) {
			url_serveur = resultSet.getString("URL_Service");

			// -------------------------------------------------------------------------
			// Prparation du site (mise a offline de tout sauf les articles
			// envoys, ajout des nouveaux champs)
			// -------------------------------------------------------------------------
			preparerSite(url_serveur);

			// ------------------------------------------------
			// Constitution de la liste d'article pour l'envoi
			// ------------------------------------------------

			MAJArticles maj = new MAJArticles(nbParEnvoi, timeout, nbRapports);
			boolean reussi = maj.lancerMAJ(url_serveur, dossierServeur, dossier_id, con, base, site_id);

			r.addParameter("reussite", reussi?"OUI":"NON");

		}

		s.closeConnection(con, null);

		return true;

	}

	// **********************************
	// * PREPARATION *
	// **********************************

	private void preparerSite(String url_serveur) {

		Object result = AppelServices.preparerSite(url_serveur);

		try {

			Object[] rep = (Object[]) result;

			Object[] rapport = (Object[]) rep[0];

			for (int i = 0; i < rapport.length; i++) {

				Object[] contenu = (Object[]) rapport[i];

				if (Integer.parseInt("" + contenu[0]) > 100) {
					publicationReussie = false;
				}

			}

		}
		catch (Exception e) {
			publicationReussie = false;
			System.out.println("[Publication.publication.preparerSite] ERREUR " + e);
		}

	}

}
