/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *  Rcupration des articles existants sur un site web
 */

package org.opensi.webmanager.init_vente;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.Vector;

import javax.imageio.stream.FileImageOutputStream;

import org.apache.axis.encoding.Base64;
import org.opensi.webmanager.utils.AppelServices;
import org.opensi.webmanager.utils.ArticleStruct;
import org.opensi.webmanager.utils.ImageStruct;
import org.opensi.webmanager.utils.MultiRapports;
import org.opensi.webmanager.utils.RedactionRapport;
import org.opensi.webmanager.utils.ToolsMAJ;

/**
 * Procdure de rcupration des articles existant sur un site.
 */
public class UploadArticles {

	private boolean noErreurRapport;

	String dateDebut;

	String dateFin;

	MultiRapports lesRapports;

	Vector<String> lesIds;

	private Object[] listeArticleEnCours;

	boolean recupEnCoursReussie;

	int nbRecupReussi;

	String rootServeur;

	String idDossier;

	/**
	 * Classe permettant de rcuprer les articles sur le site
	 * 
	 * @param dossierRoot
	 *          dossier racine de opensi-serveur
	 * @param dossierId
	 *          identifiant du dossier
	 */
	public UploadArticles(String dossierRoot, String dossierId) {

		lesRapports = new MultiRapports();
		lesIds = new Vector<String>();
		nbRecupReussi = 0;
		recupEnCoursReussie = true;
		rootServeur = dossierRoot;
		idDossier = dossierId;

	}

	/**
	 * Lance la rcupration
	 * 
	 * @param c
	 *          connection  la base de donne
	 * @param base
	 *          nom de la base en cours (FACT_qquechose)
	 * @param url_serveur
	 *          url du web service
	 * @param site_id
	 *          identifiant du site
	 * @return vrai si la rcupration a russi, faux sinon
	 */
	public boolean lancerUpload(Connection c, String base, String url_serveur, String site_id) {
		System.out.println("[lancerUpload] Dbut");

		java.util.Date date = new java.util.Date();
		Timestamp stamp = new Timestamp(date.getTime());
		dateDebut = "" + stamp;

		boolean continuer = true;

		while (continuer) {
			System.out.println("[lancerUpload] Je lance une rcup");
			recupEnCoursReussie = true;

			continuer = appelService(url_serveur);

			if (recupEnCoursReussie) {
				System.out.println("[lancerUpload] Ca a russi, j'insre");
				insertionArticles(c, base, site_id);
				nbRecupReussi++;
			}
		}

		date = new java.util.Date();
		stamp = new Timestamp(date.getTime());
		dateFin = "" + stamp;

		ecrireRapport(rootServeur, idDossier, site_id);

		boolean result = false;

		if (nbRecupReussi > 0) {
			String reqImages = "SELECT Nom_Image, Article_Id FROM " + base + ".FICHE_ARTICLE_TEMP WHERE Nom_Image<>'' AND Site_Id=" + site_id;

			try {
				Statement state = c.createStatement();
				ResultSet res = state.executeQuery(reqImages);

				while (res.next()) {

					uploadImage(url_serveur, res.getString("Article_Id"), rootServeur);
				}

			}
			catch (Exception e) {
				System.out.println("[UploadArticles]ERREUR: " + e);
			}

			result = true;
		}

		return result;
	}

	private boolean appelService(String url_serveur) {

		boolean resultFct = false;
		try {

			Object result = AppelServices.uploadArticlesExistant(url_serveur);

			Object[] rep = (Object[]) result; // valeur
			Object[] rapport = (Object[]) rep[0];// rapport

			lesRapports.addRapport(rapport);

			Object[] listeArticlesPlusBool = (Object[]) rep[1];

			// Je sais que c'est une liste d'articles
			listeArticleEnCours = (Object[]) listeArticlesPlusBool[0];
			System.out.println("syhgshresh  "+listeArticleEnCours.length);

			// Boolen indiquant si il faut continuer ou non
			resultFct = ((Boolean) listeArticlesPlusBool[1]).booleanValue();
			System.out.println("resultattt"+resultFct);

		}
		catch (Exception e) {
			System.out.println("[UploadArticles]ERREUR: " + e);
			recupEnCoursReussie = false;
		}

		return resultFct;

	}

	private void ecrireRapport(String dossierRoot, String dossierId, String site_id) {
		try {

			RedactionRapport ecriveur = new RedactionRapport(ToolsMAJ.TYPE_UPLOAD_ART, 10, dossierRoot, dossierId, site_id);

			ecriveur.ajouterLigne(dateDebut + ":La rcupration des articles a t lance", true);

			if (nbRecupReussi < 1) {
				ecriveur.ajouterLigne("\nLe site distant n'as pas pu etre atteind. Aucun article recupr.", false);
			}
			else {
				String lesDetails = "";

				int cptErreur = 0;
				int cptOk = 0;

				while (lesRapports.next()) {
					if (lesRapports.aReussi()) {
						lesDetails += "\n<br>" + lesRapports.getMessageUtilisateur();
						cptOk++;
					}
					else {
						lesDetails += "\n<br><span class=\"echec\">" + lesRapports.getMessageUtilisateur() + "</span>";
						cptErreur++;
					}

					noErreurRapport = noErreurRapport && (lesRapports.aReussi());
				}

				if (cptErreur >= 0) {
					ecriveur.ajouterLigne(dateFin + ":Tous les articles ont t rcuprs", true);
				}
				else {
					ecriveur.ajouterLigne(dateFin + ":" + cptErreur + " articles n'ont pas t rcuprs.", false);
					ecriveur.ajouterLigne(dateFin + ":" + cptOk + " articles ont t rcuprs.", true);
				}

				if (!lesDetails.equals("")) {
					ecriveur.ajouterLigne(" ****************** DETAILS **************", true);
					ecriveur.ajouterLigne(lesDetails, true);
				}

			}

			ecriveur.fermerFichier();

		}
		catch (java.io.IOException e) {
			System.out.println("[MAJPrix(ecrireRapport)] ERREUR:" + e);
		}

	}

	/*
	 * Insertion dans la table temporaire des fiche_article des articles
	 * fraichement rcuprs
	 * 
	 */
	private void insertionArticles(Connection c, String base, String site_id) {

		try {

			String reqMultiple = "INSERT INTO " + base + ".FICHE_ARTICLE_TEMP";
			reqMultiple += "(Site_Id, Article_Id, Designation, Description, Marque_Id, Famille_1, Famille_2";
			reqMultiple += ",Prix_Vente, Prix_Achat, Stock, Poids, En_Ligne, Nom_Image, Couleur_Id, Taille_Id, Collection_Id)";
			reqMultiple += " VALUES ('" + site_id + "', ?, ?, ?, ?, ?, ?";
			reqMultiple += ",?,0.0, ?, ?,'n',?,? ,?,?) ";
			
			System.out.println(reqMultiple+"  h  "+listeArticleEnCours.length);
			
			PreparedStatement ps = c.prepareStatement(reqMultiple);
			
			String reqFamille1 = "select Famille_Id from "+ base +".FAMILLE_ARTICLE where Libelle=?";
			PreparedStatement psFamille1 = c.prepareStatement(reqFamille1);
			String reqInsertFamille1 = "insert into "+ base +".FAMILLE_ARTICLE (Libelle) values (?)";
			PreparedStatement psInsertFamille1 = c.prepareStatement(reqInsertFamille1);
			
			String reqFamille2 = "select Famille_Id from "+ base +".FAMILLE_ARTICLE where Libelle=? and Parent_Id=?";
			PreparedStatement psFamille2 = c.prepareStatement(reqFamille2);
			String reqInsertFamille2 = "insert into "+ base +".FAMILLE_ARTICLE (Libelle, Parent_Id) values (?,?)";
			PreparedStatement psInsertFamille2 = c.prepareStatement(reqInsertFamille2);
			
			String reqMarque = "select Marque_Id from "+ base +".MARQUE_ARTICLE where Libelle=?";
			PreparedStatement psMarque = c.prepareStatement(reqMarque);
			String reqInsertMarque = "insert into "+ base +".MARQUE_ARTICLE (Libelle) values (?)";
			PreparedStatement psInsertMarque = c.prepareStatement(reqInsertMarque);
			
			String reqCouleur = "select Couleur_Id from "+ base +".COULEUR_ARTICLE where Libelle=?";
			PreparedStatement psCouleur = c.prepareStatement(reqCouleur);
			String reqInsertCouleur = "insert into "+ base +".COULEUR_ARTICLE (Libelle) values (?)";
			PreparedStatement psInsertCouleur = c.prepareStatement(reqInsertCouleur);
			
			String reqCollection = "select Collection_Id from "+ base +".COLLECTION_ARTICLE where Libelle=?";
			PreparedStatement psCollection = c.prepareStatement(reqCollection);
			String reqInsertCollection = "insert into "+ base +".COLLECTION_ARTICLE (Libelle) values (?)";
			PreparedStatement psInsertCollection = c.prepareStatement(reqInsertCollection);
			
			String reqTaille = "select Taille_Id from "+ base +".TAILLE_ARTICLE where Libelle=?";
			PreparedStatement psTaille = c.prepareStatement(reqTaille);
			String reqInsertTaille = "insert into "+ base +".TAILLE_ARTICLE (Libelle) values (?)";
			PreparedStatement psInsertTaille = c.prepareStatement(reqInsertTaille);

			for (int j = 0; j < listeArticleEnCours.length; j++) {
				ArticleStruct article = new ArticleStruct((Object[]) listeArticleEnCours[j]);
				
				String labMarque = article.getSqlString(article.MARQUE,40);
				String labFamille1 = article.getSqlString(article.FAMILLE,40);
				String labFamille2 = article.getSqlString(article.SOUS_FAMILLE,40);
				String labCouleur = article.getSqlString(article.COULEUR,20);
				String labTaille = article.getSqlString(article.TAILLE,20);
				String labCollection = article.getSqlString(article.COLLECTION,20);
				int marqueId = 0;
				int famille1 = 0;
				int famille2 = 0;
				int couleurId = 0;
				int tailleId = 0;
				int collectionId = 0;
				
				ResultSet rset;
				// crer les insertions et obtenir les id
				
				if (!labMarque.equals("")) {
					psMarque.setString(1, labMarque);
					rset = psMarque.executeQuery();
					if (rset.next()) {
						marqueId = rset.getInt("Marque_Id");
					}
					rset.close();
					if (marqueId==0) {
						psInsertMarque.setString(1, labMarque);
						psInsertMarque.executeUpdate();
						rset = psMarque.executeQuery();
						rset.next();
						marqueId = rset.getInt("Marque_Id");
						rset.close();
					}
				}
				
				if (labFamille1.equals("")) { labFamille1 = "Divers"; }
				psFamille1.setString(1, labFamille1);
				rset = psFamille1.executeQuery();
				if (rset.next()) {
					famille1 = rset.getInt("Famille_Id");
				}
				rset.close();
				if (famille1==0) {
					psInsertFamille1.setString(1, labFamille1);
					psInsertFamille1.executeUpdate();
					rset = psFamille1.executeQuery();
					rset.next();
					famille1 = rset.getInt("Famille_Id");
					rset.close();
				}
				
				if (labFamille2.equals("")) { labFamille2 = "Divers"; }
				psFamille2.setString(1, labFamille2);
				rset = psFamille2.executeQuery();
				if (rset.next()) {
					famille2 = rset.getInt("Famille_Id");
				}
				rset.close();
				if (famille2==0) {
					psInsertFamille2.setString(1, labFamille2);
					psInsertFamille2.setInt(2, famille1);
					psInsertFamille2.executeUpdate();
					rset = psFamille2.executeQuery();
					rset.next();
					famille2 = rset.getInt("Famille_Id");
					rset.close();
				}				
				
				if (!labCouleur.equals("")) {
					psCouleur.setString(1, labCouleur);
					rset = psCouleur.executeQuery();
					if (rset.next()) {
						couleurId = rset.getInt("Couleur_Id");
					}
					rset.close();
					if (couleurId==0) {
						psInsertCouleur.setString(1, labCouleur);
						psInsertCouleur.executeUpdate();
						rset = psCouleur.executeQuery();
						rset.next();
						couleurId = rset.getInt("Couleur_Id");
						rset.close();
					}
				}
				
				if (!labTaille.equals("")) {
					psTaille.setString(1, labTaille);
					rset = psTaille.executeQuery();
					if (rset.next()) {
						tailleId = rset.getInt("Taille_Id");
					}
					rset.close();
					if (tailleId==0) {
						psInsertTaille.setString(1, labTaille);
						psInsertTaille.executeUpdate();
						rset = psTaille.executeQuery();
						rset.next();
						tailleId = rset.getInt("Taille_Id");
						rset.close();
					}
				}
				
				if (!labCollection.equals("")) {
					psCollection.setString(1, labCollection);
					rset = psCollection.executeQuery();
					if (rset.next()) {
						collectionId = rset.getInt("Collection_Id");
					}
					rset.close();
					if (collectionId==0) {
						psInsertCollection.setString(1, labCollection);
						psInsertCollection.executeUpdate();
						rset = psCollection.executeQuery();
						rset.next();
						collectionId = rset.getInt("Collection_Id");
						rset.close();
					}
				}

				ps.setString(1, article.getSqlString(article.REFERENCE,40));
				ps.setString(2, article.getSqlString(article.DESIGNATION,100));
				ps.setString(3, article.getSqlString(article.DESCRIPTION));
				if (marqueId==0) { ps.setNull(4, Types.INTEGER); }
				else { ps.setInt(4, marqueId); }
				ps.setInt(5, famille1);
				ps.setInt(6, famille2);
				ps.setDouble(7, article.getDouble(article.TARIF_1));
				ps.setDouble(8, article.getDouble(article.STOCK));
				ps.setDouble(9, article.getDouble(article.POIDS));

				ps.setString(10, article.getSqlString(article.NOM_IMAGE,40));
				if (couleurId==0) { ps.setNull(11, Types.INTEGER); }
				else { ps.setInt(11, couleurId); }
				if (tailleId==0) { ps.setNull(12, Types.INTEGER); }
				else { ps.setInt(12, tailleId); }
				if (collectionId==0) { ps.setNull(13, Types.INTEGER); }
				else { ps.setInt(13, collectionId); }
				ps.addBatch();

				lesIds.add(article.getSqlString(article.REFERENCE,40));

			}

			ps.executeBatch();

		}
		catch (SQLException e) {
			System.out.println("[insertionArticles]ERREUR: " + e);
			e.printStackTrace();
		}

	}

	/* ******************** */
	/* * Mthodes prives * */
	/* ******************** */

	private void uploadImage(String url_serveur, String articleId, String dossierRoot) {

		System.out.println("Image de :" + articleId);

		Object result = AppelServices.uploadImage(url_serveur, articleId);

		try {

			Object[] rep = (Object[]) result;

			// Je sais que c'est une images
			Object[] valeur = (Object[]) rep[1];

			if (valeur != null && (!valeur.equals(""))) {
				// Fonction.sSysteme.creerDossierSiInexistant(dossierRoot+"/iobuffer/");

				ImageStruct imagegrande = new ImageStruct(valeur);

				if (imagegrande.getTaille() > 0 && (!imagegrande.getNom().equals(""))) {
					System.out.println("Il y a une image");

					byte[] grande_imageBinaire = Base64.decode(imagegrande.getContenu());

					File fichier_grande = new File(dossierRoot + "/iobuffer/" + imagegrande.getNom());
					fichier_grande.createNewFile();

					FileImageOutputStream output_grande = new FileImageOutputStream(fichier_grande);
					output_grande.write(grande_imageBinaire, 0, imagegrande.getTaille());
					output_grande.close();

				}

			}

		}
		catch (Exception e) {
			System.out.println("erreur [UploadArticles.uploadImage]: " + e);
		}

	}

}
