package org.opensi.webmanager.utils;

/**
 * Constantes utilisée dans le rapport d'erreur
 */
public class ConstantesRapport {

	/* ******* Constantes de reussite ********** */

	// SQL
	/**
	 * Connection au serveur reussie
	 */
	public final static int CONNEXION_SERVEUR_BASE_OK = 10;

	/**
	 * Connection à la base reussie
	 */
	public final static int CONNEXION_BASE_OK = 11;

	/**
	 * Insertion reussie
	 */
	public final static int INSERT_OK = 12;

	/**
	 * Mise a jour reussie
	 */
	public final static int UPDATE_OK = 13;

	/**
	 * Suppression reussie.
	 */
	public final static int DELETE_OK = 14;

	/**
	 * Select reussie.
	 */
	public final static int SELECT_OK = 15;

	/**
	 * Reussite
	 */
	public final static int AUTRE_OK = 0;

	/* ******** Constante d'echec *********** */
	// SQL
	/**
	 * Connection au serveur echouee
	 */
	public final static int CONNEXION_SERVEUR_BASE_KO = 110;

	/**
	 * Connection a la base echouee.
	 */
	public final static int CONNEXION_BASE_KO = 111;

	/**
	 * Insertion echouee
	 */
	public final static int INSERT_KO = 112;

	/**
	 * Mise a jour echouee
	 */
	public final static int UPDATE_KO = 113;

	/**
	 * Suppression echouee
	 */
	public final static int DELETE_KO = 114;

	/**
	 * selection echouee
	 */
	public final static int SELECT_KO = 115;

	/**
	 * autre echec
	 */
	public final static int AUTRE_KO = 200;
}
