package org.opensi.webmanager.utils;

import java.util.Vector;

/**
 * Represente un liste d'articles
 */
public class ListeArticleStruct {
	private Vector<ArticleStruct> liste;

	/**
	 * Gre un liste d'articles
	 */
	public ListeArticleStruct() {
		liste = new Vector<ArticleStruct>();
	}

	/**
	 * 
	 * @param article
	 */
	public void addArticle(ArticleStruct article) {
		liste.add(article);
	}

	/**
	 * Retourne l'article sous forme de tableau d'Object pour tre transmis via
	 * SOAP
	 */
	public Object[] getListeArticle() {
		Object[] result = new Object[liste.size()];

		for (int i = 0; i < liste.size(); i++) {
			result[i] = liste.elementAt(i).getStruct();
		}

		return result;
	}

	/**
	 * 
	 * @return
	 */
	public int getTaille() {
		return liste.size();

	}

}
