package webmaj;

import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Calendar;

import org.opensi.webmanager.utils.ToolsMAJ;

public class ServeurQuartz extends Thread {

	private File aEcrire;

	private static String type = "ServeurQuartz";

	private ServerSocket serveur;

	private Socket socket;

	private ObjectOutputStream out;

	private ObjectInputStream in;

	private String url_bd;

	private String driver_bd;

	private String login_bd;

	private String mdp_bd;

	private String dossier_root;

	private int port;

	private static QuartzManager q_manager;

	public ServeurQuartz(String url_bd, String driver_bd, String login_bd, String mdp_bd, String dossier_root, int port) {
		aEcrire = new File("ServeurQuartz.log");// le fichier de log

		this.url_bd = url_bd;
		this.driver_bd = driver_bd;
		this.login_bd = login_bd;
		this.mdp_bd = mdp_bd;
		this.dossier_root = dossier_root;
		this.port = port;
	}

	public void run() {

		try {
			q_manager = new QuartzManager();
			q_manager.init(login_bd, mdp_bd, driver_bd, url_bd, dossier_root);

			serveur = new ServerSocket(port);
			serveur.setSoTimeout(0); // infini

			String message;
			boolean continuer = true;
			int i=1;
			Calendar calendar = Calendar.getInstance();
			calendar.clear();

			while (continuer) {
				ToolsMAJ.ecrireLog(aEcrire, type, "while:\n");

				try {
					ToolsMAJ.ecrireLog(aEcrire, type, "J'attends un ordre...");

					socket = serveur.accept();
					out = new ObjectOutputStream(socket.getOutputStream());
					in = new ObjectInputStream(socket.getInputStream());

					message = (String) in.readObject();

					ToolsMAJ.ecrireLog(aEcrire, type, "Ordre reu:" + message);

					if (message.equals("AJOUTJOB")) {
						Thread.sleep(200);
						ToolsMAJ.ecrireLog(aEcrire, type, "fin du sleep...");
						ToolsMAJ.ecrireLog(aEcrire, type, "Ajout de job");

						// on rcupre les paramtres
						String maj_id = (String) in.readObject();
						ToolsMAJ.ecrireLog(aEcrire, type, "Ajout de job 1" + maj_id);
						String base = (String) in.readObject();
						ToolsMAJ.ecrireLog(aEcrire, type, "Ajout de job 2" + base);
						String dossier_id = (String) in.readObject();
						ToolsMAJ.ecrireLog(aEcrire, type, "Ajout de job 3" + dossier_id);
						String timeout = (String) in.readObject();
						ToolsMAJ.ecrireLog(aEcrire, type, "Ajout de job 4" + timeout);
						String nbRapports = (String) in.readObject();
						ToolsMAJ.ecrireLog(aEcrire, type, "Ajout de job 5" + nbRapports);
						String taillePaquets = (String) in.readObject();
						ToolsMAJ.ecrireLog(aEcrire, type, "Ajout de job 6" + taillePaquets);
						q_manager.ajouterJob(maj_id, base, dossier_id, timeout, nbRapports, taillePaquets);
						ToolsMAJ.ecrireLog(aEcrire, type, "Fin ajouter job");
					}
					else if (message.equals("RETRAITJOB")) {
						ToolsMAJ.ecrireLog(aEcrire, type, "Retrait de job");
						Thread.sleep(200);

						// on rcupre les paramtres
						String nom_job = (String) in.readObject();
						ToolsMAJ.ecrireLog(aEcrire, type, "Retrait de job 1");
						String groupe_job = (String) in.readObject();
						ToolsMAJ.ecrireLog(aEcrire, type, "Retrait de job 2");
						q_manager.retirerJob(nom_job, groupe_job);
						ToolsMAJ.ecrireLog(aEcrire, type, "Fin retrait job");

					}
					else if (message.equals("ESTDEMARRE")) {
						ToolsMAJ.ecrireLog(aEcrire, type, "Le job est il dmarr?");
						// on rcupre les paramtres
						String nom_job = (String) in.readObject();
						String groupe_job = (String) in.readObject();
						ToolsMAJ.ecrireLog(aEcrire, type,groupe_job+" nom: "+ nom_job);

						if (q_manager.estActif(nom_job, groupe_job)) {
							ToolsMAJ.ecrireLog(aEcrire, type, "==>OUI");
							out.writeObject("OUI");
						}
						else {
							ToolsMAJ.ecrireLog(aEcrire, type, "==>NON");
							out.writeObject("NON");
						}
						ToolsMAJ.ecrireLog(aEcrire, type, "Fin de: Le job est il dmarr?");

					}
					else if (message.equals("FIN")) {
						ToolsMAJ.ecrireLog(aEcrire, type, "Arret du serveur demand");
					}
					else {
						ToolsMAJ.ecrireLog(aEcrire, type, "Ordre inconnu:" + message);
					}

				} catch (Exception e) {
					calendar = Calendar.getInstance();
					ToolsMAJ.ecrireLog(aEcrire, type, "ERREURSOCKET n "+i+" le "+calendar.getTime().toString()+" impossible d ouvrir le socket:" + e);
					i++;
					Thread.sleep(500);
					if (i>100) {
						continuer=false;
					}
				}

			}// fin while

			socket.close();
			ToolsMAJ.ecrireLog(aEcrire, type, "******* Arret du Serveur *******");
			Thread.sleep(2000);
			System.exit(0);

		} catch (Exception e) {
			ToolsMAJ.ecrireLog(aEcrire, type, "ERREUR2 " + e);
		}

		// au cas ou il y aurais eu une exception ci dessus
		try {
			socket.close();
		} catch (Exception e) {
			ToolsMAJ.ecrireLog(aEcrire, type, "ERREUR " + e);
		}

	}
}
